// This file contains everything specific to item dropping
var CB;
(function (CB) {
    var ItemDrops;
    (function (ItemDrops) {
        var cb = global.craig_brett;
        function itemDrop(unit) {
            var flags = unit.ScriptFlags;
            var normalDrop = flags.get("drops_item");
            var rareDrop = flags.get("drops_rare_item");
            if (flags.get("drops_item_chance")) {
                var chance = flags.get("drops_item_chance");
                var random = Math.random().toFixed(2);
                if (random > chance) {
                    return; // no drop as they were not lucky enough
                }
            }
            var itemToCreate = normalDrop;
            if (rareDrop) {
                var rareDropChance = flags.get("drops_rare_item_chance");
                if (rareDropChance) {
                    var random = Math.random().toFixed(2);
                    if (random < rareDropChance) {
                        itemToCreate = rareDrop; // they were lucky enough to earn a rare item
                    }
                }
            }
            unit.Tile.Inventory.CreateAndAddItem(itemToCreate);
        }
        ItemDrops.itemDrop = itemDrop;
    })(ItemDrops = CB.ItemDrops || (CB.ItemDrops = {}));
})(CB || (CB = {}));
